/****** Object:  StoredProcedure [dbo].[sp_cupomfiscalrecebimento_delete_all]    Script Date: 10/07/2012 10:54:55 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_cupomfiscalrecebimento_delete_all]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_cupomfiscalrecebimento_delete_all]
GO
GO
--exec sp_cupomfiscalrecebimento_delete_all 33,'2014-06-18','2014-06-18',1
CREATE PROCEDURE [dbo].[sp_cupomfiscalrecebimento_delete_all]( @CD_FILIAL_PAR INT=0, @DT_INI DATETIME,@DT_FIM DATETIME, @FLAG_DIFERENCA INT=0)  WITH ENCRYPTION AS 
	SET NOCOUNT ON
	DECLARE @CD_EMP INT
	DECLARE @CD_FILIAL INT
	DECLARE @CD_VD INT
	DECLARE @NR_ECF INT
	DECLARE @CD_CX INT


IF @FLAG_DIFERENCA=0 
begin
	print 'Deletar recebimento geral'

	DECLARE cVdFilial CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_EMP,
		CD_FILIAL,
		CD_VD,
		NR_ECF,
		CD_CX
	FROM 
		PDV_VD
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
		AND DT_VD BETWEEN @DT_INI  AND @DT_FIM
		AND PDV_VD.ST_VD = 0
	ORDER BY
		CD_FILIAL,
		CD_CX,
		NR_ECF
end

IF @FLAG_DIFERENCA=1 
begin
	print 'Delete somente com diferenca'
	DECLARE cVdFilial CURSOR FAST_FORWARD READ_ONLY FOR 
	select
		PDV_VD.CD_EMP,
		PDV_VD.CD_FILIAL,
		PDV_VD.CD_VD,
		PDV_VD.NR_ECF,
		PDV_VD.CD_CX
	from
		PDV_VD LEFT OUTER JOIN 
		(SELECT
			CD_EMP,
			CD_FILIAL,
			CD_VD,
			SUM(VL_CARTAO) AS VLR_CARTAO
		FROM
			PDV_VD_TEF 
		GROUP BY
			PDV_VD_TEF.CD_EMP,
			PDV_VD_TEF.CD_FILIAL,
			PDV_VD_TEF.CD_VD) PDV_VD_TEF 
	ON PDV_VD.CD_EMP = PDV_VD_TEF.CD_EMP 
	AND PDV_VD.CD_FILIAL = PDV_VD_TEF.CD_FILIAL 
	AND PDV_VD.CD_VD = PDV_VD_TEF.CD_VD	
	WHERE
		(PDV_VD.VLR_LIQ_VD-(VLR_DINH+VLR_CHQS+ISNULL(PDV_VD_TEF.VLR_CARTAO,PDV_VD.VLR_CARTAO)+VLR_CONV+VLR_DUP+VLR_NCC+VLR_TICKETS+VLR_CONV_PBM)) <>0
		AND PDV_VD.CD_EMP = 1  
		AND PDV_VD.CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN PDV_VD.CD_FILIAL ELSE @CD_FILIAL_PAR END
		AND PDV_VD.DT_VD BETWEEN @DT_INI  AND @DT_FIM
		AND PDV_VD.ST_VD = 0
end

	OPEN cVdFilial
	FETCH NEXT FROM cVdFilial INTO @CD_EMP,@CD_FILIAL,@CD_VD,@NR_ECF,@CD_CX

	WHILE @@FETCH_STATUS=0
	BEGIN
		PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Cupom  ' + CONVERT(VARCHAR, @NR_ECF, 112) + ' -  caixa  ' + CONVERT(VARCHAR, @CD_CX, 112) + ' hora proc.: ' + CONVERT(VARCHAR, GETDATE (),108)
		
		exec sp_cupomfiscalrecebimento_delete @CD_EMP,@CD_FILIAL,@CD_VD	

	FETCH NEXT FROM cVdFilial INTO @CD_EMP,@CD_FILIAL,@CD_VD,@NR_ECF,@CD_CX
	END
CLOSE cVdFilial;
DEALLOCATE cVdFilial;